#!/bin/bash

# If we have no stdin, then try to run inside an xterm
stdin=$(readlink /proc/self/fd/0)
if [ "$stdin" = "/dev/null" ]; then
    cd $(dirname $0)
    for prog in x-terminal-emulator xterm; do
        exe=$(which $prog 2>/dev/null)
        if [ -x $exe ]; then
            exec $exe -e ./$(basename $0)
        fi
    done
fi

if [ "$1" = "-s" ] || [ "$1" = "--silent" ]; then

	# silent install, assumes agreement to EULA
	tar -zxf data > /dev/null
	rm -Rf data
	chmod u+x startSpeedTreeModeler.sh
	
else

	echo "Do you wish to install SpeedTree_Modeler_v10.1.0? (y/n): "
	while : ; do
		read response
		case $response in
			y|Y)
				break;
				;;
			n|N)
				exit;
				;;
			*)
				echo "Please enter 'y' or 'n': "
				;;
		esac
	done

	clear
	echo
	cat "EULA - SpeedTree v10 Products Additional Terms.txt" | pr -t -w $(tput cols) | more -d

	echo
	echo "Do you agree to this EULA? (yes/no): "
	while : ; do
		read response
		case $response in
			yes|YES|Yes)
				break;
				;;
			no|NO|No)
				exit;
				;;
			*)
				echo "Please enter 'yes' or 'no': "
				;;
		esac
	done

	echo
	echo "Installing..."

	tar -zxf data > /dev/null
	rm -Rf data
	chmod u+x startSpeedTreeModeler.sh


	echo "Installation complete!"
	echo
	echo "The SpeedTree Modeler requires xcb to run. Be sure this is installed."
	echo "     Ubuntu: sudo apt install libxcb-cursor0"
	echo "     CentOS: sudo yum install xcb*x86_64"
	echo
	echo "To run SpeedTree_Modeler_v10.1.0, run the script 'startSpeedTreeModeler.sh' in the root of the install directory."
	echo
	echo
	
fi

rm -f installSpeedTreeModeler.sh

